/* Copyright (C) 1999 Lucent Technologies */
/* Excerpted from 'The Practice of Programming' */
/* by Brian W. Kernighan and Rob Pike */

#include <iostream>
#include <algorithm>
#include <string>
#include <vector>

using namespace std;

class Csv {	// Wczytuje wartoci oddzielane przecinkami i analizuje ich skadni
    // Przykadowe dane wejciowe: "LU",86.25,"11/4/1998","2:19PM",+4.0625

  public:
    Csv(istream& fin = cin, string sep = ",") : 
        fin(fin), fieldsep(sep) {}

    int getline(string&);
    string getfield(int n);
    int getnfield() const { return nfield; }

  private:
    istream& fin;			// Wskanik na plik wejciowy
    string line;			// Wiersz wejciowy
    vector<string> field;	// acuchy reprezentujce pola
    int nfield;				// Liczba pl
    string fieldsep;		// Znaki oddzielajce

    int split();
    int endofline(char);
    int advplain(const string& line, string& fld, int);
    int advquoted(const string& line, string& fld, int);
};

// endofline: sprawdza i usuwa znaki \r, \n, \r\n oraz EOF
int Csv::endofline(char c)
{
    int eol;

    eol = (c=='\r' || c=='\n');
    if (c == '\r') {
        fin.get(c);
        if (!fin.eof() && c != '\n')
            fin.putback(c);	// Wczytano za duo
    }
    return eol;
}

// getline: pobiera jeden wiersz, zwiksza rozmiar w razie potrzeby
int Csv::getline(string& str)
{	
    char c;

    for (line = ""; fin.get(c) && !endofline(c); )
        line += c;
    split();
    str = line;
    return !fin.eof();
}

// split: dzieli wiersze na pola
int Csv::split()
{
    string fld;
    int i, j;

    nfield = 0;
    if (line.length() == 0)
        return 0;
    i = 0;

    do {
        if (i < line.length() && line[i] == '"')
            j = advquoted(line, fld, ++i);	// Pomija cudzysw
        else
            j = advplain(line, fld, i);
        if (nfield >= field.size())
            field.push_back(fld);
        else
            field[nfield] = fld;
        nfield++;
        i = j + 1;
    } while (j < line.length());

    return nfield;
}

// advquoted: pole w cudzysowie; zwraca indeks kolejnego znaku oddzielajcego
int Csv::advquoted(const string& s, string& fld, int i)
{
    int j;

    fld = "";
    for (j = i; j < s.length(); j++) {
        if (s[j] == '"' && s[++j] != '"') {
            int k = s.find_first_of(fieldsep, j);
            if (k > s.length())	// Nie znaleziono adnego znaku oddzielajcego
                k = s.length();
            for (k -= j; k-- > 0; )
                fld += s[j++];
            break;
        }
        fld += s[j];
    }
    return j;
}

// advplain: pole nie ujte w cudzysw; zwraca indeks nastpnego znaku oddzielajcego
int Csv::advplain(const string& s, string& fld, int i)
{
    int j;

    j = s.find_first_of(fieldsep, i); // Szuka znaku oddzielajcego
    if (j > s.length())               // Nie znaleziono
        j = s.length();
    fld = string(s, i, j-i);
    return j;
}


// getfield: zwraca n-te pole
string Csv::getfield(int n)
{
    if (n < 0 || n >= nfield)
        return "";
    else
        return field[n];
}

// main: testuje klas Csv
int main(void)
{
    string line;
    Csv csv;

    while (csv.getline(line) != 0) {
        cout << "line = `" << line <<"'\n";
        for (int i = 0; i < csv.getnfield(); i++)
            cout << "field[" << i << "] = `"
                 << csv.getfield(i) << "'\n";
    }
    return 0;
}
